#include<algorithm>
#include<iostream>
#include<deque>
#include<list>
#include<vector>
#include<map>
#include<sstream>

#include<cassert>
#include<tuple>

#include "minisat/minisat/core/Solver.h"
#include "qnodes.hh"

using namespace Minisat;



/* 
 * Wir stellen das Tableaux in einem SAT-Solver dar.
 * Die Literale des Solvers repräsentieren die Präfix-Formeln der ML, jedes solche
 * Literal stellt eine möglich Welt dar.
 * Es wird eine initial / aktuale Welt omega0 erstellt. Eine Präfix-Formel kodiert
 * über den Präfix die Mögliche Welt, und die Formel, die in dieser Welt gelten soll.
 * Ein Präfix-Formel (L,F) besteht aus einem Solver-Literal L und einer ML-Formel F.
 *
 * Einige der Solver-Literal korrespondieren also mit möglichen Welt (Präfixe _p),
 * andere regeln nur den Tableaux-Aufbau. (_l) strukturelle Literale
 */

//Diese Funktion nimmt eine PrefixedFormula und gibt ein zugehöriges Solver Literal zurück, die Maps Atom2Lit werden geupdatet.
//TODO: Update auch Lit2Formula


//typedef std::vector< std::vector<unsigned int> > Poset;



//Hier entseht eine Klasse.
class MLSolver {

private:

    //A SAT solver helps us to maintain a semantic tableaux and other things
	Solver solver;

	/*
	 * In agenda sind alle Literale, die noch bearbeitet werden können
	 * In processed sind alle Literale, die nicht mehr bearbeitet werden
	 * brauchen wegen alpha und beta und pi
	 *
	 */
	std::set<Lit> agenda;
	std::set<Lit> processed;   //worked off literals

	vec<Lit> assume;  //???

	GroupVar _x;

	//Possible Worlds
	
	//Some but not all SAT literals represent possible worlds.
	//(Possible worlds are exclusively encoded by positive literals)
	//Possible worlds are related by accessibility maps.
	typedef Lit world;
	typedef Lit value;
	typedef std::map< world, std::set< world > > AccessMap; //accessibility map

	world _omega;           // _omega is the actual world. (and is always true)
	AccessMap Access;       // Encodes the general accessibility relation.
	                        // Whenever the solver processes a diamond formula,
	                        // a new possible world is generated and Access is updated 
	                        // corespondingly.
	AccessMap BoxAccessed;  // Auxiliary structure to keep track whether a box formula
	                        // has already been applied to the possible world.
	

	AccessMap BoxFormula;   // Eine Box-Formel ist erreichbar. Brauchen wir für den Forall-Fall

	std::map< Lit, std::set<Group> > ForallSubstitutionGroups; //Alle Substitutionsinstanzen für die Forall-Formel.
	//AccessMap ForallSubstitutionVarGroups;                     //Alle Literale, die auf Eine entsprechende Substitution der Forall-Formel liegt vor.
	
	//AccessMap ForallSubstituted;  //Eine entsprechende Substitution der Forall-Formel liegt vor.
	
    //Das entsprechende forall Literal wurde mit der  
	typedef std::tuple< world, value, GroupVar> varvaluation;

	std::map< Lit, std::set<varvaluation> > ForallSubstVarGrpVal;
	

	
	//Semantic consequences

    //A PrefixedFormula (omega, f) is a pair of a possible world omega and a modal formula f.
	//Read this pair as "omega |= f", i.e. in the possible world omega the formula f holds.
    //Alterntive Namen: PrefixedFormula: model constraint, satisfaction, semantic consequence,
	//typedef std::pair<world, Formula> PrefixedFormula;
	typedef std::tuple<world, Lit, Formula> PrefixedFormula;
	//omega, beta |= f

	
	//Semantic tableaux

	//Ich muss nur die Prefixes für Formeln ändern.
	//Für Atome bleibt diese bestehen.
	
	//Some but not all SAT literals represent semantic consequences.
	//The branching structure of the tableaux is maintained by SAT solver clauses.
	std::map<Lit, PrefixedFormula> Lit2Formula; 

	//Sonderrolle Atome. Die stören irgendwie noch
	typedef std::pair<world, Atom> PrefixedAtom;
	std::map<PrefixedAtom, Lit> Atom2Lit;


	//Sonderrolle GroupVars
	typedef std::pair<world, GroupVar> PrefixedGroupVar;
	
	
    //The epistemic hierarchy
	
	//Zu jeder Welt kann es eigene poset-Literale geben
	std::map<world, std::vector< Lit > > poset_lits;
	std::map<PrefixedGroupVar, std::vector< Lit> > GrpVar_poset_lits;

//Muss eigentlich eine Prefixed GroupVar werden!
	
	hierarchy* H;


	
public:

	MLSolver( hierarchy* h);

	bool update_agenda();
	void add( const Formula& g );
	bool solve();
	void printModel( const Formula& f);
	void printFullModel();
	void printFullActiveModel();
	void printClauses();
	void printAgenda();
	void printProcessed();
	void printAccessibility();
	void printActiveAccessibility();
	Lit makeLit( const PrefixedFormula& pf );

	std::vector<Lit> mkSemilatticeLits();
	void mkSemilatticeEncoding( const Lit& at, const std::vector<Lit>& lit);
	void mkSemilatticeNonempty( const Lit& at, const std::vector<Lit>& lit );
	
	void makeGroupAtLit( const Lit& group);
	void addMember( const Lit& group, unsigned int m );
	
	std::vector<bool> GroupToBoolVec( const Group& g );

	Lit mkSemilatticeLEQ( const std::vector<Lit>& g1, const std::vector<Lit>& g2);
	Lit mkSemilatticeLEQ( const std::vector<bool>& g1, const std::vector<Lit>& g2);
	Lit mkSemilatticeLEQ( const std::vector<Lit>& g1, const std::vector<bool>& g2);


	void mkLEQtoLit( const Lit& p, const std::vector<bool>& g, const std::vector<Lit>& x); //?

	
	bool isLEQ( const std::vector<bool>& a, const std::vector<bool>& b);
	bool isNotLEQ( const std::vector<bool>& a, const std::vector<bool>& b);
	
	void mkLEQfromLit( const Lit& p, const std::vector<Lit>& x, const std::vector<bool>& g);
	void mkLEQfromLit( const Lit& p, const std::vector<bool>& g, const std::vector<Lit>& x);
	void mkLEQfromLit( const Lit& p, const std::vector<Lit>& x, const std::vector<Lit>& y);

	void mkNotLEQfromLit( const Lit& p, const std::vector<Lit>& x, const std::vector<bool>& g);
	void mkNotLEQfromLit( const Lit& p, const std::vector<bool>& g, const std::vector<Lit>& x);
	
	void mkNotLEQfromLit( vec<Lit>& lits, const std::vector<bool>& g, const std::vector<Lit>& x);  //lits -> ~(g<=x)
	
	friend std::ostream& operator<<( std::ostream& os, const PrefixedFormula& f );

	
private:

	
	
};
	
inline std::ostream& operator<<( std::ostream& os, const MLSolver::PrefixedFormula& f ) {
	os << "(ω_" << var( std::get<0>(f) ) << ", β_" << var( std::get<1>(f) ) << ") ⊧ " << std::get<2>(f).print();
	return os;
}

