#include<algorithm>
#include<cassert>
#include<sstream>

#include "qnodes.hh"

std::ostream& operator<<( std::ostream& os, const Group& g )
{
	//os << "{";
    bool first = true;
    for( const auto& a : g )
    {
        if( !first )
        {
            os << ",";
        }
        os << a;
		first = false;
    }
	//os << "}";
    return os;
}

/*** print methods ***/

std::string TrueNode::print()
{

	return "⊤";
}

std::string FalseNode::print()
{
	return "⊥";
}

std::string BoolNode::print()
{
	return getAtom().getName();
}

std::string NegatedNode::print()
{
    return "¬" + bodyNode->print();
}

std::string LEQNode::print()
{
    std::ostringstream oss;
    oss << lhs.getName() << "⊆" << "{" << rhs << "}";
	return std::string(oss.str());
}

std::string GEQNode::print()
{
    std::ostringstream oss;
	oss << "{" << rhs << "}" << "⊆" << lhs.getName();
	return std::string(oss.str());
}

std::string NotLEQNode::print()
{
    std::ostringstream oss;
	oss << lhs.getName() << "⊈" << "{" << rhs << "}";
	return std::string(oss.str());
}

std::string NotGEQNode::print()
{
    std::ostringstream oss;
	oss << "{" << rhs << "}" << "⊈" << lhs.getName();
	return std::string(oss.str());
}

std::string AndNode::print()
{
    return "(" + lhsNode->print() + " ∧ " + rhsNode->print() + ")";
}

std::string OrNode::print() {
	return "(" + lhsNode->print() + " ∨ " + rhsNode->print() + ")";
}

std::string DiamondNode::print() {
    std::ostringstream oss;
	oss << "⟨" << who << "⟩(" + bodyNode->print() + ")";
    return std::string(oss.str());
}

std::string DiamondVarNode::print() {
    std::ostringstream oss;
	oss << "⟨" << var.getName() << "⟩(" + bodyNode->print() + ")";
    return std::string(oss.str());
}

std::string BoxNode::print() {
    std::ostringstream oss;
    oss << "[" << who << "](" + bodyNode->print() + ")";
    return std::string(oss.str());
}

std::string BoxVarNode::print() {
    std::ostringstream oss;
    oss << "[" << var.getName() << "](" + bodyNode->print() + ")";
    return std::string(oss.str());
}

std::string WouldNode::print() {
    std::ostringstream oss;
    oss << "(" + lhsNode->print() + " [" << who << "]⇒ " + rhsNode->print() + ")";
    return std::string(oss.str());
}
std::string MightNode::print() {
    std::ostringstream oss;
	oss << "(" + lhsNode->print() + " ⟨" << who << "⟩⇒ " + rhsNode->print() + ")";
    return std::string(oss.str());
}
std::string ExistsNode::print() {
	std::ostringstream oss;
	oss << "∃";
	if( getLowerBound() != Group{} )
		oss << "{" << getLowerBound() << "}⊆";
	oss << var.getName() << "⊆" << "{" << getUpperBound() << "}";
	oss << "(" << bodyNode->print() << ")";
	return std::string(oss.str());
}

std::string ForallNode::print() {
    std::ostringstream oss;
	oss << "Ɐ";
	if( getLowerBound() != Group{} )
		oss << "{" << getLowerBound() << "}⊆";
	oss << var.getName() << "⊆" << "{" << getUpperBound() << "}";
	oss <<  "(" << bodyNode->print() << ")";
    return std::string(oss.str());
}


Formula Formula::subst(const Group& g, const GroupVar& x) const
{
	Node* n = getNode();

	if( typeid( *n ) == typeid( NegatedNode ) )
	{
		Node* n1 = ((NegatedNode*)n)->getChild();
		Formula f1( n1 );
		return f1.subst( g, x );
	}

	if( typeid( *n ) == typeid( AndNode ) )
	{
		Node* n1 = ((AndNode*)n)->getLhsNode();
		Node* n2 = ((AndNode*)n)->getRhsNode();
		Formula f1( n1 );
		Formula f2( n2 );
		return f1.subst( g, x ) & f2.subst( g, x );
	}

	if( typeid( *n ) == typeid( OrNode ) )
	{
		Node* n1 = ((OrNode*)n)->getLhsNode();
		Node* n2 = ((OrNode*)n)->getRhsNode();
		Formula f1( n1 );
		Formula f2( n2 );
		return f1.subst( g, x ) | f2.subst( g, x );
	}

	if( typeid( *n ) == typeid( BoxVarNode ) )
	{
		const GroupVar& x1 = ((BoxVarNode*)n)->getVar();
		if( x1 == x )
		{
			Node* n1 = ((BoxVarNode*)n)->getChild();
			Formula f1( n1 );
			return Box( g, f1 );
		}
		else
			return n;
	}

	if( typeid( *n ) == typeid( DiamondVarNode ) )
	{
		const GroupVar& x1 = ((DiamondVarNode*)n)->getVar();
		if( x1 == x )
		{
			Node* n1 = ((DiamondVarNode*)n)->getChild();
			Formula f1( n1 );
			return Dia( g, f1 );
		}
		else
			return n;
	}

	if( typeid( *n ) == typeid( LEQNode ) )
	{
		const GroupVar& x1 = ((LEQNode*)n)->getVar();
		const Group& g1 = ((LEQNode*)n)->getGroup();

		if( x1 == x )
		{
			if( leq( g, g1 ) )
				return new TrueNode();
			else
				return new FalseNode();
		}
		else
			return n;
	}

	if( typeid( *n ) == typeid( NotLEQNode ) )
	{
		const GroupVar& x1 = ((LEQNode*)n)->getVar();
		const Group& g1 = ((LEQNode*)n)->getGroup();

		if( x1 == x )
		{
			if( leq( g, g1 ) )
				return new FalseNode();
			else
				return new TrueNode();
		}
		else
			return n;
	}

	if( typeid( *n ) == typeid( GEQNode ) )
	{
		const GroupVar& x1 = ((LEQNode*)n)->getVar();
		const Group& g1 = ((LEQNode*)n)->getGroup();

		if( x1 == x )
		{
			if( leq( g1, g ) )
				return new TrueNode();
			else
				return new FalseNode();
		}
		else
			return n;
	}

	if( typeid( *n ) == typeid( NotGEQNode ) )
	{
		const GroupVar& x1 = ((LEQNode*)n)->getVar();
		const Group& g1 = ((LEQNode*)n)->getGroup();

		if( x1 == x )
		{
			if( leq( g1, g ) )
				return new FalseNode();
			else
				return new TrueNode();
		}
		else
			return n;
	}

	//In all other cases there is nothing to substitute
	return n;
}

Formula Formula::subst(const GroupVar& y, const GroupVar& x) const
{
	Node* n = getNode();

	if( typeid( *n ) == typeid( NegatedNode ) )
	{
		Node* n1 = ((NegatedNode*)n)->getChild();
		Formula f1( n1 );
		return f1.subst( y, x );
	}

	if( typeid( *n ) == typeid( AndNode ) )
	{
		Node* n1 = ((AndNode*)n)->getLhsNode();
		Node* n2 = ((AndNode*)n)->getRhsNode();
		Formula f1( n1 );
		Formula f2( n2 );
		return f1.subst( y, x ) & f2.subst( y, x );
	}

	if( typeid( *n ) == typeid( OrNode ) )
	{
		Node* n1 = ((OrNode*)n)->getLhsNode();
		Node* n2 = ((OrNode*)n)->getRhsNode();
		Formula f1( n1 );
		Formula f2( n2 );
		return f1.subst( y, x ) | f2.subst( y, x );
	}

	if( typeid( *n ) == typeid( BoxVarNode ) )
	{
		const GroupVar& x1 = ((BoxVarNode*)n)->getVar();
		if( x1 == x )
		{
			Node* n1 = ((BoxVarNode*)n)->getChild();
			Formula f1( n1 );
			return Box( y, f1 );
		}
		else
			return n;
	}

	if( typeid( *n ) == typeid( DiamondVarNode ) )
	{
		const GroupVar& x1 = ((DiamondVarNode*)n)->getVar();
		if( x1 == x )
		{
			Node* n1 = ((DiamondVarNode*)n)->getChild();
			Formula f1( n1 );
			return Dia( y, f1 );
		}
		else
			return n;
	}

	if( typeid( *n ) == typeid( LEQNode ) )
	{
		const GroupVar& x1 = ((LEQNode*)n)->getVar();
		const Group g1 = ((LEQNode*)n)->getGroup();
		if( x1 == x )
			return LEQ(y, g1);
		else
			return n;
	}

	if( typeid( *n ) == typeid( NotLEQNode ) )
	{
		const GroupVar& x1 = ((NotLEQNode*)n)->getVar();
		const Group& g1 = ((NotLEQNode*)n)->getGroup();
		if( x1 == x )
			return NotLEQ(y,g1);
		else
			return n;
	}

	if( typeid( *n ) == typeid( GEQNode ) )
	{
		const GroupVar& x1 = ((GEQNode*)n)->getVar();
		const Group& g1 = ((GEQNode*)n)->getGroup();
		if( x1 == x )
			return GEQ( y, g1);
		else
			return n;
	}

	if( typeid( *n ) == typeid( NotGEQNode ) )
	{
		const GroupVar& x1 = ((NotGEQNode*)n)->getVar();
		Group g1 = ((NotGEQNode*)n)->getGroup();
		if( x1 == x )
			return NotGEQ( y, g1 );
		else
			return n;
	}
	//In all other cases there is nothing to substitute
	return n;
}

//Formula stuff
Formula operator~(const Formula& lhs)
{
	Node* n = lhs.getNode();
	if( typeid( *n ) == typeid( TrueNode ) )
	{
		return new FalseNode();
	}
	else if( typeid( *n ) == typeid( FalseNode ) )
	{
		return new TrueNode();
	}
	else if( typeid( *n ) == typeid( BoolNode ) )
	{
		return new NegatedNode( n );
	}
	else if( typeid( *n ) == typeid( NegatedNode ) )
	{
		return ((NegatedNode*)n)->getChild();
	}
	else if( typeid( *n ) == typeid( AndNode ) )
	{
		Node* n1 = ((AndNode*)n)->getLhsNode();
		Node* n2 = ((AndNode*)n)->getRhsNode();
		Formula f1( n1 );
		Formula f2( n2 );
		return ~f1 | ~f2;
	}
	else if( typeid( *n ) == typeid( OrNode ) )
	{
		Node* n1 = ((OrNode*)n)->getLhsNode();
		Node* n2 = ((OrNode*)n)->getRhsNode();
		Formula f1( n1 );
		Formula f2( n2 );
		return ~f1 & ~f2;
	}
	else if( typeid( *n ) == typeid( BoxNode ) )
	{
		Node* n1 = ((BoxNode*)n)->getChild();
		Group g = ((BoxNode*)n)->getGroup();
		Formula f1( n1 );
		return Dia( g, ~f1);
	}
	else if( typeid( *n ) == typeid( BoxVarNode ) )
	{
		Node* n1 = ((BoxVarNode*)n)->getChild();
		GroupVar x = ((BoxVarNode*)n)->getVar();
		Formula f1( n1 );
		return Dia( x, ~f1);
	}
	else if( typeid( *n ) == typeid( DiamondNode ) )
	{
		Node* n1 = ((DiamondNode*)n)->getChild();
		Group g = ((DiamondNode*)n)->getGroup();
		Formula f1( n1 );
		return Box( g, ~f1);
	}
	else if( typeid( *n ) == typeid( DiamondVarNode ) )
	{
		Node* n1 = ((DiamondVarNode*)n)->getChild();
		GroupVar x = ((DiamondVarNode*)n)->getVar();
		Formula f1( n1 );
		return Box( x, ~f1);
	}
	else if( typeid( *n ) == typeid( ExistsNode ) )
	{
		Node* n1 = ((ExistsNode*)n)->getChild();
		Formula f1( n1 );
		Group lb = ((ExistsNode*)n)->getLowerBound();
		GroupVar x = ((ExistsNode*)n)->getVar();
		Group ub = ((ExistsNode*)n)->getUpperBound();
		return Fa( lb <= x <= ub, ~f1 );
	}
	else if( typeid( *n ) == typeid( ForallNode ) )
	{
		Node* n1 = ((ForallNode*)n)->getChild();
		Formula f1( n1 );
		Group lb = ((ForallNode*)n)->getLowerBound();
		GroupVar x = ((ForallNode*)n)->getVar();
		Group ub = ((ForallNode*)n)->getUpperBound();
		return Ex( lb <= x <= ub, ~f1 );
	}

	//Dangerous Nodes. These nodes are mostly used internally.
	//Negation of these nodes within quantification does not work as expected
	else if( typeid( *n ) == typeid( LEQNode ) )
	{
		std::cout << "Negation of group predicates is not supported." << std::endl;
		assert(false);
		//return new NotLEQNode( ((LEQNode*)n)->getLHS(), ((LEQNode*)n)->getRHS() );
	}
	else if( typeid( *n ) == typeid( GEQNode ) )
	{
		std::cout << "Negation of group predicates is not supported." << std::endl;
		assert(false);
		//return new NotGEQNode( ((GEQNode*)n)->getLHS(), ((GEQNode*)n)->getRHS() );
	}
	else if( typeid( *n ) == typeid( NotLEQNode ) )
	{
		std::cout << "Negation of group predicates is not supported." << std::endl;
		assert(false);
		//return new LEQNode( ((NotLEQNode*)n)->getLHS(), ((NotLEQNode*)n)->getRHS() );
	}
	else if( typeid( *n ) == typeid( NotGEQNode ) )
	{
		std::cout << "Negation of group predicates is not supported." << std::endl;
		assert(false);
		//return new GEQNode( ((NotLEQNode*)n)->getLHS(), ((NotLEQNode*)n)->getRHS() );
	}
	
	else if( typeid( *n ) == typeid( WouldNode ) )
	{
		Node* n1 = ((WouldNode*)n)->getLhsNode();
		Node* n2 = ((WouldNode*)n)->getRhsNode();
		Group g = ((WouldNode*)n)->getGroup();
		Formula f1( n1 );
		Formula f2( n2 );
		return Might( g, f1, ~f2);
	}
	else if( typeid( *n ) == typeid( MightNode ) )
	{
		Node* n1 = ((MightNode*)n)->getLhsNode();
		Node* n2 = ((MightNode*)n)->getRhsNode();
		Group g = ((MightNode*)n)->getGroup();
		Formula f1( n1 );
		Formula f2( n2 );
		return Would( g, f1, ~f2);
	}
	//Everything else is not supported yet!
	else
	{
		std::cout << "Not Supported" << std::endl;
		assert( false );
	}
}

