#include<algorithm>
#include<iostream>
#include<deque>
#include<list>
#include<vector>
#include<map>
#include<sstream>
#include <string>

#include<cassert>

#include "qnodes.hh"
#include "qsolver.hh"


//Test-Skripts

bool test( hierarchy& H, const Formula& f, bool expected)
{
	MLSolver sol( &H );
	sol.add( f );
	if( sol.solve() == expected)
	{
		return true;
	}
	else
	{
		std::cout << "Test for " << f.print() << " failed!" 
				  << std::endl;
		return false;
	}
}

int main()
{
	//Gruppenbildung
	assert( ( Group{3,2,1} == Group{1,2,3} ) );
	assert( ( Group{1,2} != Group{1,3} ) );
	GroupVar x("X");
	qterm t0 = Group{3,2,1} <= x <= Group{1,2,3,4};
	qterm t1 = x <= Group{1};
	qterm t2 = Group{1,2,3,4} <= x;
	std::cout << std::get<0>(t0) << "<=" << std::get<1>(t0).getName() << "<=" << std::get<2>(t0) << std::endl;
	std::cout << std::get<0>(t1) << "<=" << std::get<1>(t1).getName() << "<=" << std::get<2>(t1) << std::endl;
	std::cout << std::get<0>(t2) << "<=" << std::get<1>(t2).getName() << "<=" << std::get<2>(t2) << std::endl;

	{
		Atom a("a");
		GroupVar x("X");
		Poset P { {}, {}, {} };
		hierarchy H( P );

		//test( H, Box( Group{3}, ~a) & Dia( Group{0,1}, a), true );
		//ACHTUNG: Ich hätte gerne falsche Gruppen abgefangen
		
		assert( test( H, Box( Group{2}, ~a) & Dia( Group{0,1}, a), true ) );
		assert( test( H, Fa( x <= Group{0,1}, Dia(x, a) ) & Box( Group{2}, ~a), true ) );

		//Eine Allaussage und eine Modalität, die beide wahr sind, aber erst falsch wird, wenn auch die Instanz betrachtet wird.
		assert( test( H, Fa( x <= Group{0,1,2}, Dia( x, a ) ) & Box( Group{2}, ~a), false ) );
		assert( test( H, Fa( x <= Group{0,1,2}, Dia( x, a ) ) & Ex( x <= Group{2}, Box( x, ~a)), false ) );
		//Letztere Aussage ist schon falsch, weil auch folgende Aussage falsch ist
		assert( test( H, Dia( Group{0,1,2}, a ) & Ex( x <= Group{2}, Box( x, ~a)), false ) );
		//Also nicht das gesuchte Beispiel.

		//Wir müssen eine Dia-Aussage außerhalb des All-Quantors haben, damit wir nicht nach oben vererben
		assert( test( H, Dia( Group{2}, ~a ) & Fa( x <= Group{0,1,2}, Box( x, a) ), false) );
		assert( test( H, Ex( x <= Group{2}, Dia( x, ~a )) & Fa( x <= Group{0,1,2}, Box( x, a) ), false) );
        //test( H, Fa( x <= Group{0,1,2}, Box(x, TRUE) ) & Dia( {0,1,2}, FALSE);
        //test( H, Fa( x <= Group{0,1,2}, Box(x, TRUE) ) & Dia( {0,1,2}, FALSE), false); ?
	}

	{
		//Observation-Problem
		//Ein Sensor 
		//
		Poset P { {}, {0} };
		hierarchy H( P );

		Atom lane_blocked("lane_blocked");

		Group o1 = Group{ 0 };
		Group o = Group{0,1};

		GroupVar x("x");

		//Wir wissen nicht, ob die Spur blockiert ist
		Formula obs_explicit = Dia( o1, lane_blocked ) & Dia( o1, ~lane_blocked);
		Formula obs_implicit = Fa( x <= o, Dia( x, lane_blocked ) & Dia( x, ~lane_blocked)); //Achtung, das ist mehr!

		//obs_explicit <!> obs_implicit
		Formula f = (~obs_explicit | obs_implicit) & (~obs_implicit | obs_explicit);
		assert( test( H, f, true ) );  //ist erfüllbar
		assert( test( H, ~f, true ) ); //ist auch erfüllbar!

		//Jetzt schon
		obs_explicit = obs_explicit & Dia( o, lane_blocked ) & Dia( o, ~lane_blocked);
		f = (~obs_explicit | obs_implicit) & (~obs_implicit | obs_explicit);
		assert( test( H, f, true ) );
		assert( test( H, ~f, false ) );
				
	}

	{
		//Observation-Problem
		//Zwei Sensoren 
		//
		Poset P { {}, {}, {0,1} };
		hierarchy H( P );

		Atom lane_blocked("lane_blocked");

		Group o1 = Group{ 0 };
		Group o2 = Group{ 1 };
		Group o = Group{0,1,2};

		GroupVar x("x");

		//Wir wissen nicht, ob die Spur blockiert ist
		Formula obs_explicit = Dia( o1, lane_blocked ) & Dia( o1, ~lane_blocked)
			& Dia( o2, lane_blocked ) & Dia( o2, ~lane_blocked)
			& Dia( Group{0,1}, lane_blocked) & Dia( Group{0,1}, ~lane_blocked)
			& Dia( o, lane_blocked) & Dia( o, ~lane_blocked )
			;
		Formula obs_implicit = Fa( x <= o, Dia( x, lane_blocked ) & Dia( x, ~lane_blocked));

		//obs_explicit <-> obs_implicit
		Formula f = (~obs_explicit | obs_implicit) & (~obs_implicit | obs_explicit);
		assert( test( H, f, true ) );
		assert( test( H, ~f, false ) );

	}

	{
		//Observation-Problem
		//Drei Sensoren 
		//
		Poset P { {}, {}, {}, {0,1,2} };
		hierarchy H( P );

		Atom lane_blocked("lane_blocked");

		Group o1 = Group{ 0 };
		Group o2 = Group{ 1 };
		Group o3 = Group{ 2 };
		Group o = Group{0,1,2,3};
		Group o_components = Group{0,1,2};

		GroupVar x("x");

		//Wir wissen nicht, ob die Spur blockiert ist
		Formula obs_explicit = Dia( o1, lane_blocked ) & Dia( o1, ~lane_blocked)
			& Dia( o2, lane_blocked ) & Dia( o2, ~lane_blocked)
			& Dia( o3, lane_blocked ) & Dia( o3, ~lane_blocked)
			& Dia( Group{0,1}, lane_blocked) & Dia( Group{0,1}, ~lane_blocked)
			& Dia( Group{1,2}, lane_blocked) & Dia( Group{1,2}, ~lane_blocked)
			& Dia( Group{0,2}, lane_blocked) & Dia( Group{0,2}, ~lane_blocked)
			& Dia( Group{0,1,2}, lane_blocked) & Dia( Group{0,1,2}, ~lane_blocked)
			;
		Formula obs_implicit = Fa( x <= o, Dia( x, lane_blocked ) & Dia( x, ~lane_blocked));

		//obs_explicit <!> obs_implicit
		Formula f = (~obs_explicit | obs_implicit) & (~obs_implicit | obs_explicit);
		assert( test( H, f, true ) );
		assert( test( H, ~f, true ) );
		

		Formula observer_rule = ~Fa( x <= o_components, Dia( x, lane_blocked) | Dia( x, lane_blocked) ) | Box(o, lane_blocked);

		//Die Observer Regel ist keineswegs triviallerweise wahr
		assert( test( H, observer_rule, true ) );
		assert( test( H, ~observer_rule, true ) );

		assert( test( H, obs_explicit & Box( o, lane_blocked), true) );  //unwichtig

		//Die Observer Regel ist konsistent mit den Oberservations
		assert( test( H, obs_explicit & observer_rule, true) );
		assert( test( H, ~(obs_explicit & observer_rule), true) );

	}
}
