#include<algorithm>
#include<iostream>
#include<deque>
#include<list>
#include<vector>
#include<map>
#include<sstream>
#include <string>

#include<cassert>

#include "qnodes.hh"
#include "qsolver.hh"

int main()
{
	//FM-Paper

    //Declare the epistemic hierarchy according to Fig. 1

	/*
	 * P is a vector of 12 sets.
	 * Each entry of this vector is an entity.
	 * Empty sets denote atoms.
	 * Non-empty sets denote an non-atomic entity.
	 * The elements enumerate all entities that are strict smaller.
	 *
     * E.g., the 0th entry {} declares an atom,
	 * and the 4th entry {0,1,2,3} declares an entity whose 
	 * children correspond to the 0th, 1st, 2nd and 3rd entry.
	 *
	 * Presumably it is not needed to encode the transitive closure.
	 * However, this is not tested yet.
	 */
	
	Poset P { {}, {}, {}, {}, {0,1,2,3},
			  {}, {}, {0,1,2,3,4,5,6},
			  {}, {}, {0,1,2,3,4,5,6,7,8,9},
			  {0,1,2,3,4,5,6,7,8,9,10}
	};

	//We declare some names.
	//Unfortunately they won't occur in the output
	//of the solver.
	
	Group r1 { 0 };
	Group r2 { 1 };
	Group r3 { 2 };
	Group r4 { 3 };
	Group r_c { 0,1,2,3 };
	Group r { 0,1,2,3,4 };
	Group o1 = { 5 };
	Group o2 = { 6 };
	Group o_c = { 0,1,2,3,4,5,6 };
	Group o = { 0,1,2,3,4,5,6,7};
	Group g1 = { 8 };
	Group g2 = { 9 };
	Group g_c = { 0,1,2,3,4,5,6,7,8,9 };
	Group g = { 0,1,2,3,4,5,6,7,8,9,10 };
	Group s_c = { 0,1,2,3,4,5,6,7,8,9,10 };  //s_c = g!
	Group s = {0,1,2,3,4,5,6,7,8,9,10,11};
	Group all = { 0,1,2,3,4,5,6,7,8,9,10,11 };  //all=s

	GroupVar x("x");

	hierarchy H( P );

	//We declare some atoms
	Atom laneBlocked("laneBlocked");
	Atom brake("brake");
	Atom changeLane("changeLane");
	Atom beFast("beFast");
	Atom gapAvailable("gapAvailable");
	Atom beConsiderate("beConsiderate");
	Atom largeGapAvailable("largeGapAvailable");

	//We define Sigma.
	//Box(o1, xx) encodes the modal operator [o1]xx.
	//Dia(o1, xx) encodes the modal operator <o1>xx.

	Formula Observed =
		Box( o1, laneBlocked )
		& Box( o2, gapAvailable & ~largeGapAvailable );

	//The rules are usually fixed
	Formula Rules =
		Box( r1, ~laneBlocked | brake | changeLane )
		& Box( r2, ~changeLane | gapAvailable )
		& Box( r3, ~beFast | ~brake )
		& Box( r4, ~beConsiderate | ~changeLane | largeGapAvailable );

	//Goals
	Formula Goals =
		Box( g1, beFast );


	Formula defaultGoals =
		~Fa( x <= g_c, ~Dia(x,true) | Dia(x, beConsiderate) ) |
		Box( g, beConsiderate);

	Formula Sigma = Rules & Observed & Goals & defaultGoals;

	Formula f = Sigma & Fa( x <= all, Dia(x, true));

	//Performs a satisfiablity check of f
	MLSolver sol( &H );

	sol.add( f );
	if( sol.solve() ) {
		std::cout << "satisfiable!" << std::endl;
		sol.printModel(f);
	}
	else
	{
		std::cout << "unsatisfiable!" << std::endl;
	}

}
